/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelRTF;
import DE.siemens.ad.logo.dialog.comp.display.OneCharacterCellEditor;
import DE.siemens.ad.logo.dialog.comp.display.RectangleElementsDisplayModel;
import DE.siemens.ad.logo.model.panel.MessageEditorPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SymbolInsertPanel
extends DataInputPanel {
    private int fCharset;
    private LogoDisplay fSymbolDisplay;
    private LogoDisplay fLogoDisplay;
    private JScrollPane scrollPane;
    private LogoDisplay.CellsTransferable fCellsTransferable;
    private JTextField fCodeTextField;
    private JLabel fCodeLabel;
    private JPanel codePanel;

    public SymbolInsertPanel(LogoDisplay logoDisplay, int charset, LogoDisplay.CellsTransferable cellsTransferable) {
        this.fCharset = charset;
        this.fLogoDisplay = logoDisplay;
        this.fCellsTransferable = cellsTransferable;
        this.initialize();
        this.loadSymbol(this.fCharset);
    }

    private void initialize() {
        int width = (this.fLogoDisplay.getDefaultCellDimesion().width + this.fLogoDisplay.fInterCellSpacing.width) * this.fLogoDisplay.fDisplayDimension.width;
        int height = (this.fLogoDisplay.getDefaultCellDimesion().height + this.fLogoDisplay.fInterCellSpacing.height) * this.fLogoDisplay.fDisplayDimension.height;
        this.setLayout(new GridBagLayout());
        this.setSize(800, 800);
        if (this.fSymbolDisplay == null) {
            this.fSymbolDisplay = new LogoDisplay(){

                public boolean isCellSelected(Point location) {
                    return this.getFocusPosition().equals(location) && this.getModel().getElementAt(location) != null;
                }

                public void moveFocus(int dx, int dy, boolean extendSelection) {
                    Rectangle cellBounds = this.fModel.getElementBounds(this.fFocusPosition);
                    Point oldPosition = new Point(this.fFocusPosition);
                    if (dy == -1) {
                        this.fFocusPosition.y = Math.max(cellBounds.y - 1, 0);
                    }
                    if (dy == 1) {
                        this.fFocusPosition.y = Math.min(cellBounds.y + cellBounds.height, this.fDisplayDimension.height - 1);
                    }
                    if (dx == 1) {
                        this.fFocusPosition.x = Math.min(cellBounds.x + cellBounds.width, this.fDisplayDimension.width - 1);
                    }
                    if (dx == -1) {
                        this.fFocusPosition.x = Math.max(cellBounds.x - 1, 0);
                    }
                    if (SymbolInsertPanel.this.fSymbolDisplay.getModel().getElementAt(this.fFocusPosition) == null) {
                        this.fFocusPosition = oldPosition;
                        return;
                    }
                    this.setFocusPosition(this.fModel.getElementBounds(this.fFocusPosition).getLocation());
                    this.repaint();
                }
            };
            this.fSymbolDisplay.setModel(new SymbolModel(this.fLogoDisplay.getDisplayDimension(), this.fCharset));
            this.fSymbolDisplay.setDefaultCellEditor(new OneCharacterCellEditor());
            this.fSymbolDisplay.removeMouseListener(this.fSymbolDisplay.getMouseListeners()[0]);
            this.fSymbolDisplay.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    Point clickPoint = SymbolInsertPanel.this.fSymbolDisplay.convertPointToCell(e.getPoint());
                    DisplayElement element = SymbolInsertPanel.this.fSymbolDisplay.getModel().getElementAt(clickPoint);
                    if (element == null) {
                        return;
                    }
                    SymbolInsertPanel.this.fSymbolDisplay.setFocusPosition(clickPoint);
                    SymbolInsertPanel.this.setCodeTextField();
                    if (2 == e.getClickCount()) {
                        SymbolInsertPanel.this.getOkButton().doClick();
                        return;
                    }
                    SymbolInsertPanel.this.repaint();
                }
            });
        }
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.fSymbolDisplay);
            this.scrollPane.setPreferredSize(new Dimension(width + 2, height * 2 + 2));
            this.scrollPane.setMinimumSize(new Dimension(width, height));
        }
        GridBagConstraints constraint = new GridBagConstraints();
        constraint.fill = 2;
        constraint.gridx = 0;
        constraint.gridy = 0;
        this.add((Component)this.scrollPane, constraint);
        constraint.gridx = 0;
        constraint.gridy = 1;
        this.add((Component)this.getCodePanel(), constraint);
    }

    private JPanel getCodePanel() {
        if (this.codePanel == null) {
            this.codePanel = new JPanel(new GridBagLayout());
            this.fCodeLabel = new JLabel(Language.getString("dialog.parameter.message.characterCode", "Character Code (hex):") + " ");
            this.fCodeTextField = new JTextField(5);
            this.setCodeTextField();
            GridBagConstraints constraint = new GridBagConstraints();
            constraint.fill = 2;
            constraint.insets = new Insets(5, 0, 0, 0);
            constraint.gridx = 0;
            constraint.gridy = 0;
            this.codePanel.add((Component)this.fCodeLabel, constraint);
            constraint.gridx = 1;
            constraint.gridy = 0;
            this.codePanel.add((Component)this.fCodeTextField, constraint);
            constraint.gridx = 2;
            constraint.gridy = 0;
            constraint.weightx = 1.0;
            this.codePanel.add((Component)new JPanel(), constraint);
        }
        return this.codePanel;
    }

    private void setCodeTextField() {
        DisplayElement element = this.fSymbolDisplay.getModel().getElementAt(this.fSymbolDisplay.getFocusPosition());
        if (element != null) {
            this.fCodeTextField.setText(this.getHexCode(element));
        }
    }

    public int getCharset() {
        return this.fCharset;
    }

    public void setCharset(int charset) {
        this.fCharset = charset;
        this.fSymbolDisplay.setModel(new SymbolModel(this.fLogoDisplay.getDisplayDimension(), this.fCharset));
        this.loadSymbol(charset);
    }

    public void loadFieldContents() throws ProgramException {
        super.loadFieldContents();
        this.fSymbolDisplay.clearSelection();
    }

    public boolean checkFieldContents() {
        DisplayElement element = this.fSymbolDisplay.getModel().getElementAt(this.fSymbolDisplay.getFocusPosition());
        if (element == null) {
            return false;
        }
        return super.checkFieldContents();
    }

    public void storeFieldContents() {
        List selectedCells = this.fSymbolDisplay.getSelectedCells();
        List elements = this.fSymbolDisplay.getModel().getCellsElements(selectedCells);
        this.fCellsTransferable.setLogoDisplay(this.fSymbolDisplay);
        this.fCellsTransferable.setCells(selectedCells);
        this.fCellsTransferable.setElements(elements);
    }

    public void showManualEditPanel(LogoDisplay.CellsTransferable clipboardTransferable) {
        LogoError dialog = new LogoError(null, "dialog.logdisplay.conflictOccure", "Position conflict with another message text element.\n Edit manually?", 1, 1);
        if (dialog.display() == 0) {
            this.getParent().setVisible(false);
            MessageEditorPanel editorPanel = new MessageEditorPanel((MessageParameterDisplayModelRTF)this.fLogoDisplay.getModel());
            editorPanel.setClipboardContent(clipboardTransferable);
            SplittedDlg panel = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), editorPanel, 3);
            panel.show();
            if (panel.getControlPanel().getResult() == 1) {
                this.fLogoDisplay.repaint();
            }
        }
    }

    public void setLabels() {
        super.setLabels();
        this.getOkButton().setText(Language.getString("msg.insert.title", "Insert"));
    }

    private void loadSymbol(int charset) {
        ((SymbolModel)this.fSymbolDisplay.getModel()).loadCharacters(charset);
        this.setName(Language.getString("dialog.parameter.message.symbol", "Symbol") + ": " + MessageGlobalInfo.getCharSetName(this.fCharset));
    }

    private String getHexCode(DisplayElement element) {
        StringBuffer ret = new StringBuffer("0x");
        byte[] code = MessageGlobalInfo.getCharsetEncoding(this.fCharset, element.toString().charAt(0));
        for (int i = 0; i < code.length; ++i) {
            ret.append(Integer.toHexString(code[i] & 0xFF));
        }
        return ret.toString();
    }

    protected static class SymbolModel
    extends RectangleElementsDisplayModel {
        static final int Dimension_Height = 8;

        public SymbolModel(Dimension dimension, int charSet) {
            super(new Dimension(dimension.width, 8), charSet);
            this.loadCharacters(charSet);
        }

        protected void loadCharacters(int charSet) {
            this.clearAll();
            int elementWidth = 1;
            int lineNumber = 0;
            int columnNumber = 0;
            for (int curByte = 33; curByte <= 255; ++curByte) {
                String object = "";
                if (curByte <= 126) {
                    elementWidth = 1;
                    object = Character.toString((char)curByte);
                } else {
                    if (this.isBiWidthCharacterset()) {
                        return;
                    }
                    if (charSet == 16) {
                        String[][] charMap = MessageGlobalInfo.getISO885916UnicodeMap();
                        for (int i = 0; i < charMap.length; ++i) {
                            this.setElementAt(new DefaultDisplayElement(charMap[i][1], 1, 1), new Point(columnNumber, lineNumber));
                            if (columnNumber + 2 * elementWidth > this.getDisplayDimension().width) {
                                columnNumber = 0;
                                ++lineNumber;
                                continue;
                            }
                            columnNumber += elementWidth;
                        }
                        return;
                    }
                    if (curByte < 160) {
                        curByte = 160;
                        continue;
                    }
                    object = Character.toString(MessageGlobalInfo.getUnicodeChar(charSet, new byte[]{(byte)curByte}));
                }
                this.setElementAt(new DefaultDisplayElement(object, elementWidth, 1), new Point(columnNumber, lineNumber));
                if (columnNumber + 2 * elementWidth > this.getDisplayDimension().width) {
                    columnNumber = 0;
                    ++lineNumber;
                    continue;
                }
                columnNumber += elementWidth;
            }
        }

        public boolean isCellEditable(Point location) {
            return false;
        }

        public boolean deleteCells(List cells) {
            return true;
        }

        public boolean deleteElement(Point location) {
            return true;
        }

        public boolean isCopyPasteSupported() {
            return false;
        }

        public void clearAll() {
            for (int i = 0; i < this.fDisplayDimension.width; ++i) {
                for (int j = 0; j < this.fDisplayDimension.height; ++j) {
                    this.fDisplayElements[i][j] = null;
                }
            }
        }
    }
}

